*
* Estimating free coefficients
*
open data nile.dat
calendar 1871
data(format=free,org=columns,skips=1) 1871:1 1970:1 nile
*
* Concentrating out the measurement error variance, estimating the
* relative state variance in log form.
*
nonlin psi
compute psi=0.0
dlm(a=1.0,c=1.0,sv=1.0,sw=exp(psi),y=nile,$
  method=bfgs,var=concentrate,presample=diffuse) 1871:1 1970:1
*
* Direct estimation of both variances.
*
nonlin sigsqeps sigsqeta
stats(noprint) nile
compute sigsqeps=.5*%variance,sigsqeta=.1*sigsqeps
*
dlm(a=1.0,c=1.0,sv=sigsqeps,sw=sigsqeta,y=nile,$
  method=bfgs,presample=diffuse) 1871:1 1970:1
*
* Estimation with sigsqeta pegged to zero
*
nonlin sigsqeps sigsqeta=0.0
dlm(a=1.0,c=1.0,sv=sigsqeps,sw=sigsqeta,y=nile,$
  method=bfgs,presample=diffuse) 1871:1 1970:1

